(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to assign one or more Xbots to a Stream.
 * Maximum 8 streams can be configured with 1 command
 * Depending on the configuration, 10 or more axes can be stream.
 * Multiple Xbot can follow 1 stream.
 * Stream is updated when MsgFrame[99] is updated.
 * 
 *Input:
 * MsgFrame     (Profinet output frame)
 * ReadFrame    (Profinet reply frame)
 * Execute      (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label    (Optional 2 byte Command label. Used to identify specfic commands.
 * NumOfXbot    (Number of Xbot to move)
 * StreamOption (0 = Stop Stream, 1 = Start Stream)
 * Xbot ID[0..7]      (Xbot to Move. XbotID > 0. Can only move 1 at the time. Virtual Axis ID 100-127, Macro ID 128-191
 * StreamID[0..7]      (StreamID linked to specific XbotID. Target X Position in mm)
 * AxesID[0..7]   (Streaming Axes ID. Bitmap Bit[5:0] : [RZ,RY,RX,Z,Y,X] AxesID = 1: Only X, AxesID = 3, Only X and Y etc.)
 * XOffset[0..7]      (Starting position X)
 * YOffset[0..7]      (Starting Position Y)
 * 
 *
 * Output:
 * Error (Indicates if there is an error)
 * Busy  (FuB will be Busy until reply)
 * Done  (When Accepted command is received, Done = TRUE) 
 * ErrorID (0x0001 = System Error, 0x2000 = Wrong PMC State, 0x2001 = No Mastership, 0x2002 = Mastership timeout,
 *		    0x2003 = Wrong group state, 0x2004 = Wrong Macro state, 0x2005 = Wrong Digital IO state,
 *          0x2006 = Wrong flyways state, 0x3000 = Wrong Xbot state, 0x4000 = Paramter Error: Invalid Parameters.
 *********************************************************************************)






FUNCTION_BLOCK PM_StreamControl
	// Check Reply
	IF(Busy)THEN
		brsmemcpy(ADR(CmdLbl),ADR(ReadFrame[3]),2);
		IF(ReadFrame[0] = CmdCount AND
			ReadFrame[1] 	= 14  AND
			ReadFrame[2]	= 11 AND
			CmdLbl = CmdLabel)THEN
			Done 	:= TRUE;
			Busy 	:= FALSE;
			brsmemcpy(ADR(ErrorID),ADR(ReadFrame[5]),2);
			Error 	:= UINT_TO_BOOL(ErrorID);
			Done 	:= NOT(UINT_TO_BOOL(ErrorID));
		ELSE
			Busy := FALSE;
		END_IF;
	END_IF;
	//Send Command		
	IF(Execute AND NOT(Done) AND NOT(Error))THEN
		IF(NOT(Busy))THEN
			brsmemset(ADR(MsgFrame[1]),FALSE,98);
			CmdCount 		:= ReadFrame[0] +1;
			MsgFrame[0] 	:= CmdCount; 
			MsgFrame[1] 	:= 14;
			MsgFrame[2] 	:= 11;
			brsmemcpy(ADR(MsgFrame[3]), ADR(CmdLabel), 2);
			MsgFrame[5]		:= 1;
			MsgFrame[9] 	:= NumOfXbot;
			MsgFrame[10]	:= StreamOption; // 0 = stop, 1 = start
			FOR count := 0 TO NumOfXbot DO
				MsgFrame[11+(STREAM_CONTROL_BYTE_SEQUENCE*count)] 	:= XbotID[count];		
				MsgFrame[12+(STREAM_CONTROL_BYTE_SEQUENCE*count)]	:= StreamID[count];
				MsgFrame[13+(STREAM_CONTROL_BYTE_SEQUENCE*count)]	:= AxesID[count];
				Xmm2m[count] 										:= XOffset[count]/1000.0;
				Ymm2m[count]										:= YOffset[count]/1000.0;
			
				brsmemcpy(ADR(MsgFrame[14+(STREAM_CONTROL_BYTE_SEQUENCE*count)]), ADR(Xmm2m[count]), 4);
				brsmemcpy(ADR(MsgFrame[18+(STREAM_CONTROL_BYTE_SEQUENCE*count)]), ADR(Ymm2m[count]), 4);				
			END_FOR;		
			Busy 			:= TRUE;	
		END_IF;
		
	ELSIF(NOT(Execute))THEN
		Busy 	:= FALSE;
		Done 	:= FALSE;
		Error 	:= FALSE;
		ErrorID := 0;
		
	END_IF
	
	//Incremental counter for streaming mode. Execute needs to be active all time.
	IF(Execute)THEN
		MsgFrame[99] := MsgFrame[99]+1;
	END_IF;
	
	
	
END_FUNCTION_BLOCK
